@extends('layouts.app')

@section('content')
<!-- Hero Section -->
<div class="relative bg-teal-900 text-white overflow-hidden">
    <div class="absolute inset-0 z-0 opacity-40">
        <!-- Abstract patterns or image replacement -->
        <img src="https://images.unsplash.com/photo-1588854337221-4cf9fa96059c?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80" alt="Plomberie Moderne" class="w-full h-full object-cover">
    </div>
    <div class="absolute inset-0 bg-gradient-to-r from-teal-900 via-teal-900/90 to-transparent z-0"></div>
    
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-32 lg:py-48 flex flex-col justify-center h-full">
        <h1 class="text-5xl lg:text-7xl font-extrabold tracking-tight mb-6 leading-tight">
            L'Excellence <br>
            <span class="text-transparent bg-clip-text bg-gradient-to-r from-teal-200 to-teal-400">Technique à Votre Service</span>
        </h1>
        <p class="text-xl lg:text-2xl text-teal-100 mb-10 max-w-2xl font-light">
            DÉCO BAT transforme vos espaces avec une expertise certifiée en plomberie, CVC et isolation.
        </p>
        <div class="flex flex-col sm:flex-row gap-4">
            <a href="{{ route('contact') }}" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-lg font-bold rounded-lg text-teal-900 bg-white hover:bg-teal-50 hover:scale-105 transition-all duration-300 shadow-xl">
                Demander un Devis
                <svg class="w-5 h-5 ml-2 -mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
            </a>
            <a href="{{ route('plomberie') }}" class="inline-flex items-center justify-center px-8 py-4 border-2 border-teal-500 text-lg font-semibold rounded-lg text-teal-100 hover:bg-teal-800/50 hover:border-teal-400 transition-all duration-300 backdrop-blur-sm">
                Découvrir Nos Services
            </a>
        </div>
    </div>
</div>

<!-- Features Strip -->
<div class="bg-white relative z-20 -mt-16 mx-4 sm:mx-auto max-w-7xl rounded-xl shadow-2xl grid grid-cols-1 md:grid-cols-3 divide-y md:divide-y-0 md:divide-x divide-gray-100 overflow-hidden">
    <div class="p-8 flex items-center space-x-4 hover:bg-teal-50 transition-colors duration-300 group">
        <div class="p-3 bg-teal-100 text-teal-600 rounded-lg group-hover:bg-teal-600 group-hover:text-white transition-colors">
            <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
        </div>
        <div>
            <h3 class="font-bold text-gray-900 text-lg">Intervention Rapide</h3>
            <p class="text-sm text-gray-500">Service d'urgence 7j/7 dans le Val d'Oise</p>
        </div>
    </div>
    <div class="p-8 flex items-center space-x-4 hover:bg-teal-50 transition-colors duration-300 group">
        <div class="p-3 bg-teal-100 text-teal-600 rounded-lg group-hover:bg-teal-600 group-hover:text-white transition-colors">
            <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
        </div>
        <div>
            <h3 class="font-bold text-gray-900 text-lg">Artisans Certifiés</h3>
            <p class="text-sm text-gray-500">Expertise RGE et garantie décennale</p>
        </div>
    </div>
    <div class="p-8 flex items-center space-x-4 hover:bg-teal-50 transition-colors duration-300 group">
        <div class="p-3 bg-teal-100 text-teal-600 rounded-lg group-hover:bg-teal-600 group-hover:text-white transition-colors">
            <svg class="w-8 h-8" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 6l3 1m0 0l-3 9a5.002 5.002 0 006.001 0M6 7l3 9M6 7l6-2m6 2l3-1m-3 1l-3 9a5.002 5.002 0 006.001 0M18 7l3 9m-3-9l-6-2m0-2v2m0 16V5m0 16H9m3 0h3"/></svg>
        </div>
        <div>
            <h3 class="font-bold text-gray-900 text-lg">Tarifs Transparents</h3>
            <p class="text-sm text-gray-500">Devis gratuit et détaillé avant travaux</p>
        </div>
    </div>
</div>

<!-- Services Section -->
<section class="py-24 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-base font-bold text-teal-600 tracking-wide uppercase">Nos Expertises</h2>
            <p class="mt-2 text-4xl leading-8 font-extrabold tracking-tight text-gray-900 sm:text-5xl">Solutions Complètes pour l'Habitat</p>
            <p class="mt-4 max-w-2xl text-xl text-gray-500 mx-auto">De l'installation à la maintenance, nous couvrons tous les aspects de votre confort domestique.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
            <!-- Service 1 -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-2xl transition-shadow duration-300 flex flex-col group">
                <div class="h-48 bg-teal-600 overflow-hidden relative">
                    <img src="https://images.unsplash.com/photo-1507925921958-8a62f3d1a50d?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Plomberie" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                    <div class="absolute inset-0 bg-teal-900/30 group-hover:bg-teal-900/10 transition-colors"></div>
                </div>
                <div class="p-8 flex-1 flex flex-col">
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">Plomberie Sanitaire</h3>
                    <p class="text-gray-600 mb-6 flex-1">Installation et rénovation de salles de bain, cuisines, et gestion de tous vos réseaux d'eau.</p>
                    <a href="{{ route('plomberie') }}" class="text-teal-600 font-semibold hover:text-teal-800 inline-flex items-center">
                        En savoir plus <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                    </a>
                </div>
            </div>

            <!-- Service 2 -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-2xl transition-shadow duration-300 flex flex-col group">
                <div class="h-48 bg-orange-500 overflow-hidden relative">
                    <img src="https://images.unsplash.com/photo-1504148455328-c376907d081c?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="CVC" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                    <div class="absolute inset-0 bg-orange-900/30 group-hover:bg-orange-900/10 transition-colors"></div>
                </div>
                <div class="p-8 flex-1 flex flex-col">
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">Chauffage & CVC</h3>
                    <p class="text-gray-600 mb-6 flex-1">Solutions de chauffage performantes, climatisation et ventilation pour un air sain.</p>
                    <a href="{{ route('cvc') }}" class="text-orange-600 font-semibold hover:text-orange-800 inline-flex items-center">
                        En savoir plus <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                    </a>
                </div>
            </div>

            <!-- Service 3 -->
            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden hover:shadow-2xl transition-shadow duration-300 flex flex-col group">
                <div class="h-48 bg-teal-700 overflow-hidden relative">
                    <img src="https://images.unsplash.com/photo-1629814421689-08709ca17282?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Isolation" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                    <div class="absolute inset-0 bg-teal-900/30 group-hover:bg-teal-900/10 transition-colors"></div>
                </div>
                <div class="p-8 flex-1 flex flex-col">
                    <h3 class="text-2xl font-bold text-gray-900 mb-4">Isolation</h3>
                    <p class="text-gray-600 mb-6 flex-1">Isolation thermique et phonique pour réduire vos factures et améliorer votre confort de vie.</p>
                    <a href="{{ route('isolation') }}" class="text-teal-600 font-semibold hover:text-teal-800 inline-flex items-center">
                        En savoir plus <svg class="w-4 h-4 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About / CTA Section -->
<section class="py-24 bg-teal-900 text-white relative overflow-hidden">
    <!-- Decorative blobs -->
    <div class="absolute top-0 right-0 -mr-20 -mt-20 w-96 h-96 rounded-full bg-teal-800 blur-3xl opacity-50"></div>
    <div class="absolute bottom-0 left-0 -ml-20 -mb-20 w-96 h-96 rounded-full bg-teal-600 blur-3xl opacity-30"></div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="lg:grid lg:grid-cols-2 lg:gap-16 items-center">
             <div>
                <h2 class="text-3xl font-extrabold tracking-tight sm:text-4xl mb-6">Pourquoi choisir DÉCO BAT ?</h2>
                <div class="space-y-6 text-lg text-teal-100">
                    <p>
                        Entreprise familiale basée à St Brice Sous Forêt, nous mettons un point d'honneur à offrir un service de proximité irréprochable.
                    </p>
                    <ul class="space-y-4">
                        <li class="flex items-center">
                            <span class="flex-shrink-0 h-8 w-8 rounded-full bg-teal-500 flex items-center justify-center mr-3">
                                <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            </span>
                            Devis gratuits et détaillés sans surprise
                        </li>
                        <li class="flex items-center">
                            <span class="flex-shrink-0 h-8 w-8 rounded-full bg-teal-500 flex items-center justify-center mr-3">
                                <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            </span>
                            Respect des délais et des lieux
                        </li>
                        <li class="flex items-center">
                            <span class="flex-shrink-0 h-8 w-8 rounded-full bg-teal-500 flex items-center justify-center mr-3">
                                <svg class="w-5 h-5 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                            </span>
                            Accompagnement pour les aides (MaPrimeRénov')
                        </li>
                    </ul>
                </div>
                <div class="mt-10">
                    <a href="{{ route('contact') }}" class="inline-block bg-white py-4 px-10 border border-transparent rounded-lg font-bold text-teal-900 hover:bg-teal-50 hover:shadow-lg transition-all transform hover:-translate-y-1">
                        Contactez-nous aujourd'hui
                    </a>
                </div>
            </div>
            <div class="mt-12 lg:mt-0 relative">
                <div class="aspect-w-3 aspect-h-2 rounded-2xl overflow-hidden shadow-2xl rotate-2 hover:rotate-0 transition-transform duration-500">
                     <img class="object-cover" src="https://images.unsplash.com/photo-1581094794329-cd56b71a61f3?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80" alt="Chantier">
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
