<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="scroll-smooth">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'DÉCO BAT - Artisan Plombier Val d\'Oise')</title>
    <meta name="description" content="@yield('description', 'Artisan plomberie, chauffage et isolation certifié RGE à St Brice Sous Forêt.')">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Styles / Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <style>
        body { font-family: 'Outfit', sans-serif; }
        .glass-nav {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0,0,0,0.05);
        }
    </style>
</head>
<body class="antialiased text-gray-800 bg-gray-50 flex flex-col min-h-screen">
    
    <!-- Navigation -->
    <nav class="fixed w-full z-50 glass-nav transition-all duration-300" id="navbar">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-20">
                <!-- Logo -->
                <div class="flex-shrink-0 flex items-center gap-3">
                    <a href="{{ route('home') }}" class="flex items-center gap-2 group">
                        <div class="w-10 h-10 bg-gradient-to-br from-teal-500 to-teal-700 rounded-lg flex items-center justify-center text-white shadow-lg group-hover:shadow-teal-500/30 transition-all duration-300">
                            <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"/>
                            </svg>
                        </div>
                        <span class="font-bold text-2xl tracking-tight text-gray-900">DÉCO<span class="text-teal-600">BAT</span></span>
                    </a>
                </div>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="{{ route('home') }}" class="text-sm font-medium text-gray-600 hover:text-teal-600 transition-colors {{ request()->routeIs('home') ? 'text-teal-600 font-semibold' : '' }}">Accueil</a>
                    <a href="{{ route('plomberie') }}" class="text-sm font-medium text-gray-600 hover:text-teal-600 transition-colors {{ request()->routeIs('plomberie') ? 'text-teal-600 font-semibold' : '' }}">Plomberie</a>
                    <a href="{{ route('cvc') }}" class="text-sm font-medium text-gray-600 hover:text-teal-600 transition-colors {{ request()->routeIs('cvc') ? 'text-teal-600 font-semibold' : '' }}">CVC</a>
                    <a href="{{ route('isolation') }}" class="text-sm font-medium text-gray-600 hover:text-teal-600 transition-colors {{ request()->routeIs('isolation') ? 'text-teal-600 font-semibold' : '' }}">Isolation</a>
                    <a href="{{ route('contact') }}" class="relative inline-flex items-center justify-center px-6 py-2 overflow-hidden font-medium text-white transition duration-300 ease-out border-2 border-teal-600 rounded-full shadow-md group">
                        <span class="absolute inset-0 flex items-center justify-center w-full h-full text-white duration-300 -translate-x-full bg-teal-600 group-hover:translate-x-0 ease">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                        </span>
                        <span class="absolute flex items-center justify-center w-full h-full text-teal-600 transition-all duration-300 transform group-hover:translate-x-full ease">Devis Gratuit</span>
                        <span class="relative invisible">Devis Gratuit</span>
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden flex items-center">
                    <button class="mobile-menu-button outline-none text-gray-600 hover:text-teal-600 focus:text-teal-600 transition-colors p-2">
                        <svg class="w-6 h-6" fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor">
                            <path d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div class="hidden mobile-menu md:hidden bg-white border-t border-gray-100 shadow-xl absolute w-full left-0">
            <div class="px-4 py-6 space-y-3">
                <a href="{{ route('home') }}" class="block px-4 py-3 text-gray-600 hover:bg-teal-50 hover:text-teal-600 rounded-lg transition-colors font-medium border-l-4 border-transparent hover:border-teal-500 {{ request()->routeIs('home') ? 'bg-teal-50 text-teal-600 border-teal-500' : '' }}">Accueil</a>
                <a href="{{ route('plomberie') }}" class="block px-4 py-3 text-gray-600 hover:bg-teal-50 hover:text-teal-600 rounded-lg transition-colors font-medium border-l-4 border-transparent hover:border-teal-500 {{ request()->routeIs('plomberie') ? 'bg-teal-50 text-teal-600 border-teal-500' : '' }}">Plomberie</a>
                <a href="{{ route('cvc') }}" class="block px-4 py-3 text-gray-600 hover:bg-teal-50 hover:text-teal-600 rounded-lg transition-colors font-medium border-l-4 border-transparent hover:border-teal-500 {{ request()->routeIs('cvc') ? 'bg-teal-50 text-teal-600 border-teal-500' : '' }}">Chauffage & CVC</a>
                <a href="{{ route('isolation') }}" class="block px-4 py-3 text-gray-600 hover:bg-teal-50 hover:text-teal-600 rounded-lg transition-colors font-medium border-l-4 border-transparent hover:border-teal-500 {{ request()->routeIs('isolation') ? 'bg-teal-50 text-teal-600 border-teal-500' : '' }}">Isolation</a>
                <a href="{{ route('contact') }}" class="block w-full mt-4 bg-teal-600 text-white text-center px-4 py-3 rounded-lg font-bold shadow-lg shadow-teal-500/30 hover:bg-teal-700 transition-colors">Demander mon Devis</a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="flex-grow pt-20">
        @yield('content')
    </main>

    <!-- Footer -->
    <footer class="bg-slate-900 text-slate-300 pt-16 pb-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12 mb-12">
                <!-- Brand -->
                <div class="col-span-1 lg:col-span-1">
                    <a href="{{ route('home') }}" class="flex items-center gap-2 mb-6 text-white">
                        <div class="w-8 h-8 bg-teal-600 rounded-lg flex items-center justify-center text-white">
                            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"/>
                            </svg>
                        </div>
                        <span class="font-bold text-xl tracking-tight">DÉCO BAT</span>
                    </a>
                    <p class="text-sm leading-relaxed text-slate-400 mb-6">Expertise et qualité pour tous vos travaux de plomberie, chauffage et isolation dans le Val d'Oise. Artisan certifié RGE.</p>
                </div>

                <!-- Services -->
                <div>
                    <h3 class="text-white font-semibold text-lg mb-6">Nos Services</h3>
                    <ul class="space-y-3">
                        <li><a href="{{ route('plomberie') }}" class="hover:text-teal-400 transition-colors text-sm">Plomberie Sanitaire</a></li>
                        <li><a href="{{ route('cvc') }}" class="hover:text-teal-400 transition-colors text-sm">Chauffage & CVC</a></li>
                        <li><a href="{{ route('isolation') }}" class="hover:text-teal-400 transition-colors text-sm">Isolation Thermique</a></li>
                        <li><a href="{{ route('contact') }}" class="hover:text-teal-400 transition-colors text-sm">Dépannage Urgence</a></li>
                    </ul>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="text-white font-semibold text-lg mb-6">Informations</h3>
                    <ul class="space-y-3">
                        <li><a href="{{ route('contact') }}" class="hover:text-teal-400 transition-colors text-sm">Nous Contacter</a></li>
                        <li><a href="{{ route('contact') }}#faq" class="hover:text-teal-400 transition-colors text-sm">FAQ</a></li>
                        <li><span class="text-slate-500 text-sm cursor-not-allowed">Mentions Légales</span></li>
                        <li><span class="text-slate-500 text-sm cursor-not-allowed">Politique de Confidentialité</span></li>
                    </ul>
                </div>

                <!-- Contact -->
                <div>
                    <h3 class="text-white font-semibold text-lg mb-6">Contact</h3>
                    <ul class="space-y-4">
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 text-teal-500 mt-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <span class="text-sm">7 Rue de la petit St Brice<br>95350 St Brice Sous Forêt</span>
                        </li>
                        <li class="flex items-center gap-3">
                            <svg class="w-5 h-5 text-teal-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                            <a href="tel:+331XXXXXXXXX" class="text-sm hover:text-teal-400 transition-colors">01 XX XX XX XX</a>
                        </li>
                        <li class="flex items-center gap-3">
                            <svg class="w-5 h-5 text-teal-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            <a href="mailto:contact@decobat.fr" class="text-sm hover:text-teal-400 transition-colors">contact@decobat.fr</a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="border-t border-slate-800 pt-8 flex flex-col md:flex-row justify-between items-center gap-4">
                <p class="text-sm text-slate-500">© {{ date('Y') }} DÉCO BAT. Tous droits réservés. SIRET: 85303029400047</p>
                <div class="flex space-x-4">
                    <!-- Social icons placeholder -->
                    <a href="#" class="text-slate-500 hover:text-teal-400 transition-colors"><span class="sr-only">Facebook</span><svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953h-1.517c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg></a>
                </div>
            </div>
        </div>
    </footer>

    <script>
        // Mobile Menu Toggle
        const btn = document.querySelector(".mobile-menu-button");
        const menu = document.querySelector(".mobile-menu");

        btn.addEventListener("click", () => {
            menu.classList.toggle("hidden");
        });
    </script>
</body>
</html>
