@extends('layouts.app')

@section('title', 'Plomberie Sanitaire & Dépannage | DÉCO BAT')
@section('description', 'Installation sanitaire, rénovation de salle de bain et dépannage urgence fuite d\'eau. Plombier certifié Val d\'Oise.')

@section('content')
<!-- Header -->
<div class="relative bg-teal-800 py-24 sm:py-32">
    <div class="absolute inset-0 overflow-hidden">
        <img src="https://images.unsplash.com/photo-1584622650111-993a426fbf0a?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80" alt="Plomberie" class="w-full h-full object-cover opacity-20">
        <div class="absolute inset-0 bg-gradient-to-r from-teal-900 to-teal-800/80 mix-blend-multiply"></div>
    </div>
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center sm:text-left">
        <h1 class="text-4xl font-extrabold text-white sm:text-5xl sm:tracking-tight lg:text-6xl">Plomberie Sanitaire</h1>
        <p class="mt-6 text-xl text-teal-100 max-w-3xl">Expertise complète pour vos installations, rénovations et dépannages d'urgence.</p>
    </div>
</div>

<!-- Main Content -->
<div class="bg-white py-16 sm:py-24">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12">
            
            <!-- Details -->
            <div class="lg:col-span-2">
                <h2 class="text-3xl font-bold text-gray-900 mb-8">Nos Prestations</h2>
                
                <div class="space-y-12">
                    <div class="flex gap-6">
                        <div class="flex-shrink-0">
                            <div class="flex items-center justify-center h-12 w-12 rounded-md bg-teal-500 text-white">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z" /></svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Installation Sanitaire</h3>
                            <p class="mt-2 text-gray-500">Pose de robinetterie, WC (classique et suspendu), lavabos, douches à l'italienne et baignoires. Nous sélectionnons les plus grandes marques pour garantir durabilité et design.</p>
                        </div>
                    </div>

                    <div class="flex gap-6">
                        <div class="flex-shrink-0">
                            <div class="flex items-center justify-center h-12 w-12 rounded-md bg-orange-500 text-white">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Dépannage d'Urgence</h3>
                            <p class="mt-2 text-gray-500">Recherche de fuites non destructives, débouchage de canalisations, réparation de chauffe-eau. Intervention rapide 7j/7 pour minimiser les dégâts.</p>
                        </div>
                    </div>

                    <div class="flex gap-6">
                        <div class="flex-shrink-0">
                            <div class="flex items-center justify-center h-12 w-12 rounded-md bg-teal-600 text-white">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" /></svg>
                            </div>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900">Rénovation Complète</h3>
                            <p class="mt-2 text-gray-500">Création de salle de bain clé en main. De la conception au carrelage, nous gérons l'ensemble du chantier pour transformer votre pièce d'eau.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1 space-y-8">
                <div class="bg-gray-50 p-6 rounded-2xl border border-gray-100 shadow-sm">
                    <h3 class="text-lg font-bold text-gray-900 mb-4">Besoin d'un plombier ?</h3>
                    <p class="text-gray-600 mb-6 text-sm">Nos équipes interviennent dans tout le Val d'Oise pour vos urgences et travaux.</p>
                    <a href="{{ route('contact') }}" class="w-full flex items-center justify-center px-4 py-3 border border-transparent rounded-md shadow-sm text-base font-medium text-white bg-teal-600 hover:bg-teal-700">
                        Demander un devis
                    </a>
                </div>
                
                <div class="bg-teal-900 rounded-2xl p-6 text-white shadow-lg">
                    <h3 class="text-lg font-bold mb-4">Pourquoi nous ?</h3>
                    <ul class="space-y-3 text-sm text-teal-100">
                        <li class="flex items-center"><svg class="w-4 h-4 mr-2 text-teal-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg> Assurance décennale</li>
                        <li class="flex items-center"><svg class="w-4 h-4 mr-2 text-teal-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg> Devis et déplacement gratuits</li>
                        <li class="flex items-center"><svg class="w-4 h-4 mr-2 text-teal-400" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg> Matériel professionnel</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
